﻿using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk.Workflow;
using System.Linq;
using System.Activities;
using System;
using System.Collections.Generic;
using VA.PPMS.Context;

namespace VA.PPMS.Workflows.PAAction
{

    public sealed class PAExpirationAction : CodeActivity
    {
       
        [Input("ExpirationDateFilter")]
        public InArgument<string> FilterDate { get; set; }

        [Output("CountofExpiredAgreements")]
        public OutArgument<int> AgreementCount { get; set; }

        protected override void Execute(CodeActivityContext executionContext)
        {
            //Create the tracing service
            ITracingService tracingService = executionContext.GetExtension<ITracingService>();

            //Create the context
            IWorkflowContext context = executionContext.GetExtension<IWorkflowContext>();
            IOrganizationServiceFactory serviceFactory = executionContext.GetExtension<IOrganizationServiceFactory>();
            IOrganizationService service = serviceFactory.CreateOrganizationService(context.UserId);

            tracingService.Trace("Provider Agreement Action");

            //Get the Agreements which are "expired"
            AgreementCount.Set(executionContext, 0);

            DateTime today = DateTime.Now;
            today = today.AddDays(1);
           
            //string filterdate = today.ToString("d");
            string filterdate = today.ToString("yyyy-MM-dd");
            filterdate += "T00:01:01+00:00";
            
            tracingService.Trace("Filterdate is \"" + filterdate + "\"");
            

            string  fetchXmlExpiredAgrements = @" 
<fetch>
  <entity name='ppms_provideragreement' >
    <attribute name='ppms_agreementid' />
    <attribute name='ppms_qualificationexpirationdate' />
    <attribute name='ppms_effectivedate' />
    <attribute name='ppms_expirationdate' />
    <attribute name='ppms_medicaldirectorsignaturedate' />
    <attribute name='ppms_provideragreementid' />
    <attribute name='ppms_statusswitch' />
    <filter type='and' >
      <filter type='or' >
        <condition attribute='ppms_expirationdate' operator='le' value='" + filterdate + @"' /> 
        <condition attribute='ppms_qualificationexpirationdate' operator='le' value='" + filterdate + @"' />
      </filter>
      <filter type='and' >
        <condition attribute='statecode' operator='eq' value='0' />
        <filter type='or' >
          <condition attribute='ppms_statusswitch' operator='null' />
          <condition attribute='ppms_statusswitch' operator='eq' value='0' />
        </filter>
      </filter>
     <filter type='or' >
        <condition attribute='ppms_expirationdate' operator='not-null' />
        <condition attribute='ppms_qualificationexpirationdate' operator='not-null' />
      </filter> 
    </filter>
  </entity>
</fetch>";
            tracingService.Trace(fetchXmlExpiredAgrements);

           // Retrieving cases using fetchXml
           var agreements = service.RetrieveMultiple(
                new FetchExpression(
                    fetchXmlExpiredAgrements));

            // Null check
            if (agreements == null || agreements?.Entities == null) return;
            // now update each item in turn to trigger the business workflow
            // 
            tracingService.Trace("PAExpirationAction - Agreements Returned: " + agreements.Entities.Count);
            int i = 0;
            using (var contextBatch = new PpmsContext(service))
            {
                foreach (Entity agreement in agreements.Entities)
                {

                    //Update the status switch field on the entity
                    var updateEntity = new ppms_provideragreement();

                    string aid = agreement.GetAttributeValue<string>("ppms_agreementid");
                    //tracingService.Trace("new record" + agreement.Id.ToString());
                    updateEntity.Id = agreement.Id;
                    updateEntity.ppms_StatusSwitch = true;
                    updateEntity.ppms_StatusSwitchDate = DateTime.UtcNow;
                    //tracingService.Trace("switch = " + updateEntity.ppms_StatusSwitch + " on " + updateEntity.ppms_StatusSwitchDate);
                    contextBatch.Attach(updateEntity);
                    contextBatch.UpdateObject(updateEntity);
                    tracingService.Trace("PAExpirationAction - Agreement " + i + " "  + aid + " updated: " + updateEntity.Id.ToString());
                    i++;
                    if (i % 100 == 0 || i >= agreements.Entities.Count)
                    {
                        contextBatch.SaveChanges();
                        tracingService.Trace("batch run through " + i);
                    }
                }
            }
            AgreementCount.Set(executionContext, i);
        }


    }
}
